IF EXISTS (SELECT * FROM SYS.OBJECTS WHERE NAME = 'UFD_CG_EXTRATO_FORN')
	DROP FUNCTION [dbo].[UFD_CG_EXTRATO_FORN]
GO
GO
--SELECT * FROM UFD_CG_EXTRATO_FORN (1,90,'2010-01-01','2011-03-13')
CREATE FUNCTION [dbo].[UFD_CG_EXTRATO_FORN] (@CD_EMP		INT, 
												@CD_FORN	INT,
												@DT_INI		DATETIME,
												@DT_FIM		DATETIME
											)	
RETURNS @RS_RETORNO TABLE (	TP_LANC			INT,
							CD_FND_VERBA	INT,
							DT_LANCTO		DATETIME,
							CD_FORN			INT,
							VERBA			VARCHAR(200),
							HIST			VARCHAR(200),
							NEGOCIADO		MONEY,	
							CREDITO			MONEY,
							DEBITO			MONEY,
							SLD_USO			MONEY,
							SLD_RECB		MONEY,
							ORDEM			INT,
							TP_LANC_CONTRATO INT)
AS
BEGIN
	INSERT INTO @RS_RETORNO
	SELECT * FROM
	(
		SELECT 
				2 TP_LANC,
				0 CD_FND_VERBA,	
				DT_LANCTO,
				CD_FORN,
				VERBA,
				HIST,
				NEGOCIADO,
				CREDITO,
				DEBITO,
				SLD_USO,
				SLD_RECB,	
				0 ORDEM,
				0 AS TP_LANC_CONTRATO
		FROM
			 UFD_CG_EXTRATO_FORN_SLD_ANT (@CD_EMP,@CD_FORN,@DT_INI)
		UNION ALL
		SELECT 
				3 TP_LANC,
				V.CD_FND_VERBA,	
				V.DT_LANCTO,
				V.CD_FORN,
				V.HIST_LANC  COLLATE SQL_Latin1_General_CP1_CI_AS  VERBA,
				'LANCAMENTO DE VERBA: ' + CAST(V.CD_FND_VERBA AS VARCHAR) COLLATE SQL_Latin1_General_CP1_CI_AS  HIST,
				(VLR_LANC - VLR_GLOSA)   AS NEGOCIADO,
				0 AS CREDITO,
				0 AS DEBITO,
				(VLR_LANC - VLR_GLOSA),
				CASE WHEN V.TP_LANC = 0 THEN
					(VLR_LANC - VLR_GLOSA)
				ELSE
					0 
				END AS SLD_RECB,
				1 ORDEM,
				V.TP_LANC AS TP_LANC_CONTRATO
			FROM 
				CG_FND_VERBA V 				
			WHERE
				V.CD_EMP=@CD_EMP
				AND V.CD_FORN = @CD_FORN
				AND V.DT_LANCTO BETWEEN @DT_INI AND @DT_FIM
			UNION ALL
			SELECT
				1 TP_LANC,
				V.CD_FND_VERBA,	
				R.DT_RECEB,
				V.CD_FORN,
				V.HIST_LANC COLLATE SQL_Latin1_General_CP1_CI_AS  VERBA, 
				R.HIST_LANC  COLLATE SQL_Latin1_General_CP1_CI_AS ,
				(VLR_LANC - VLR_GLOSA) AS NEGOCIADO,
				R.VLR_RECB AS CREDITO,
				0 AS DEBITO,
				(VLR_LANC - VLR_GLOSA) - 
				ISNULL((SELECT SLD_RECB FROM UFD_CG_RETORNA_SALDO_RECEB_FORN (1, 
													V.CD_FND_VERBA,
													R.CD_FND_VERBA_RECB,
													V.CD_FORN,
													R.DT_RECEB)),0) AS SLD_USO,
				ISNULL((SELECT SLD_RECB FROM UFD_CG_RETORNA_SALDO_RECEB_FORN (@CD_EMP, 
																V.CD_FND_VERBA,
																R.CD_FND_VERBA_RECB,
																V.CD_FORN,
																R.DT_RECEB)),0)  AS SLD_RECB,
				2 ORDEM,
				V.TP_LANC AS TP_LANC_CONTRATO
			FROM 
				CG_FND_VERBA V
				INNER JOIN 	CG_FND_VERBA_RECB R ON
				V.CD_EMP = R.CD_EMP AND
				V.CD_FND_VERBA = R.CD_FND_VERBA
			WHERE
				V.CD_EMP=@CD_EMP
				AND R.STATUS=0
				AND V.CD_FORN = @CD_FORN		
				AND R.DT_RECEB BETWEEN @DT_INI AND @DT_FIM
			UNION ALL
			SELECT
				0 TP_LANC,
				V.CD_FND_VERBA,	
				S.DT_SAQUE,
				CD_FORN,
				V.HIST_LANC  COLLATE SQL_Latin1_General_CP1_CI_AS  VERBA, 
				LEFT('SAQUE - ' +  HIST_SAQ, 200)  COLLATE SQL_Latin1_General_CP1_CI_AS  HIST,
				(VLR_LANC - VLR_GLOSA) AS NEGOCIADO,
				0 AS CREDITO,
				S.VLR_SAQUE AS DEBITO,
				CASE WHEN V.TP_LANC = 0 THEN
					(VLR_LANC - VLR_GLOSA) - ISNULL((SELECT SLD_USO FROM UFD_CG_RETORNA_SALDO_USO_FORN (@CD_EMP, 
																V.CD_FND_VERBA,
																V.CD_FORN,														
																S.DT_SAQUE)),0) 
				ELSE
					ISNULL((SELECT SLD_RECB FROM UFD_CG_RETORNA_SALDO_RECEB_FORN (@CD_EMP, 
																	V.CD_FND_VERBA,0,
																	V.CD_FORN,
																	S.DT_SAQUE)),0)
					- ISNULL((SELECT SLD_USO FROM UFD_CG_RETORNA_SALDO_USO_FORN (@CD_EMP, 
																V.CD_FND_VERBA,
																V.CD_FORN,														
																S.DT_SAQUE)),0)
				END AS SLD_USO,
				CASE WHEN V.TP_LANC = 0 THEN
					(VLR_LANC - VLR_GLOSA) - ISNULL((SELECT SLD_RECB FROM UFD_CG_RETORNA_SALDO_RECEB_FORN (@CD_EMP, 
																	V.CD_FND_VERBA,0,
																	V.CD_FORN,
																	S.DT_SAQUE)),0)
				ELSE
					0 
				END AS SLD_RECB,
				3 ORDEM,
				V.TP_LANC AS TP_LANC_CONTRATO
			FROM 
				CG_FND_VERBA V
				INNER JOIN CG_FND_VERBA_SAQUE S ON
				V.CD_EMP = S.CD_EMP AND
				V.CD_FND_VERBA = S.CD_FND_VERBA
			WHERE
				V.CD_EMP=@CD_EMP
				AND S.STATUS=0
				AND V.CD_FORN = @CD_FORN
				AND S.DT_SAQUE BETWEEN @DT_INI AND @DT_FIM
			UNION ALL
			SELECT
				0 TP_LANC,
				V.CD_FND_VERBA,	
				P.DT_CAD,
				V.CD_FORN,
				V.HIST_LANC  COLLATE SQL_Latin1_General_CP1_CI_AS  VERBA, 
				'ALOCAO DE VERBA PROD. REF.: ' + CONVERT(VARCHAR, CD_PROD)  COLLATE SQL_Latin1_General_CP1_CI_AS  HIST,
				(VLR_LANC - VLR_GLOSA) AS NEGOCIADO,
				0 AS CREDITO,
				P.VLR_VERBA_TOT AS DEBITO,
				(VLR_LANC - VLR_GLOSA) - ISNULL(
				(SELECT SLD_USO FROM UFD_CG_RETORNA_SALDO_USO_FORN (@CD_EMP, 
																V.CD_FND_VERBA,
																V.CD_FORN,
																P.DT_CAD)),0) AS SLD_USO,
				(VLR_LANC - VLR_GLOSA) - ISNULL((SELECT SLD_RECB FROM UFD_CG_RETORNA_SALDO_RECEB_FORN (@CD_EMP, 
																V.CD_FND_VERBA,0,
																V.CD_FORN,
																P.DT_CAD)),0) AS SLD_RECB,
				4 ORDEM,
				V.TP_LANC AS TP_LANC_CONTRATO
			FROM 
				CG_FND_VERBA V
				INNER JOIN CG_FND_VERBA_PROD P ON
				V.CD_EMP = P.CD_EMP AND
				V.CD_FND_VERBA = P.CD_FND_VERBA
			WHERE
				V.CD_EMP=@CD_EMP
				AND V.CD_FORN = @CD_FORN
				AND P.DT_CAD BETWEEN @DT_INI AND @DT_FIM
				AND P.VLR_VERBA_TOT > 0 
				) TBL 
	ORDER BY CD_FND_VERBA, DT_LANCTO, ORDEM
	RETURN
END

GO


